unit notify;
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, shellApi;
type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Image1: TImage;
    Timer1: TTimer;
    Image2: TImage;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
var
  Form1: TForm1;
  MyNotifyStruct: TNotifyIconData;
{ // Here is the structure info from ShellAPI.pas:
  type
    PNotifyIconDataA = ^TNotifyIconDataA;
    PNotifyIconDataW = ^TNotifyIconDataW;
    PNotifyIconData = PNotifyIconDataA;
    TNotifyIconDataA = record
      cbSize: DWORD;
      Wnd: HWND;
      uID: UINT;
      uFlags: UINT;
      uCallbackMessage: UINT;
      hIcon: HICON;
      szTip: array [0..63] of AnsiChar;
    end;
    TNotifyIconDataW = record
      cbSize: DWORD;
      Wnd: HWND;
      uID: UINT;
      uFlags: UINT;
      uCallbackMessage: UINT;
      hIcon: HICON;
      szTip: array [0..63] of WideChar;
    end;
    TNotifyIconData = TNotifyIconDataA;
}
implementation
{$R *.DFM}
procedure TForm1.Button1Click(Sender: TObject);
begin
  with MyNotifyStruct do begin
    cbSize:= sizeof(MyNotifyStruct);
    Wnd:= form1.handle;
    uID:= 1;
    uFlags:=  NIF_ICON or NIF_TIP;
    hIcon:= Image1.picture.icon.handle;
    szTip:= 'Hello Lloyd';
  end;
  Shell_NotifyIcon(NIM_ADD, @MyNotifyStruct);
end;
procedure TForm1.Button2Click(Sender: TObject);
begin
  Shell_NotifyIcon(NIM_Delete, @MyNotifyStruct);
end;
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  StrPCopy(MyNotifyStruct.szTip,TimetoStr(Time));
  if (MyNotifyStruct.hIcon = image1.picture.icon.handle) then
     MyNotifyStruct.hIcon:= image2.picture.icon.handle
  else
     MyNotifyStruct.hIcon:= image1.picture.icon.handle;

  Shell_NotifyIcon(NIM_Modify, @MyNotifyStruct);
end;
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Shell_NotifyIcon(NIM_Delete, @MyNotifyStruct); // clean up
end;
end.

{ DFM file }
object Form1: TForm1
  Left = 331
  Top = 141
  Width = 435
  Height = 300
  Caption = 'Form1'
  Font.Color = clWindowText
  Font.Height = -11
  Font.Name = 'MS Sans Serif'
  Font.Style = []
  OnClose = FormClose
  PixelsPerInch = 96
  TextHeight = 13
  object Image1: TImage
    Left = 249
    Top = 39
    Width = 34
    Height = 31
    Picture.Data = {
      055449636F6E0000010001002020100000000000E80200001600000028000000
      2000000040000000010004000000000080020000000000000000000000000000
      0000000000000000000080000080000000808000800000008000800080800000
      80808000C0C0C0000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000
      FFFFFF00999999999999999999999999999999999FFFFFFFFFFFFF8888888888
      8FFFFFF997FFFFFFFFFF888888888888888FFFF9977FFFFFFFF8444C44488888
      8888FFF99777FFFFFF4444444444488888888FF997777FFF44444C4C4C4C4C48
      888888F9977777F44444443444444444888888F99777774C444C433C4C4C4C4C
      48888889977774444444C334C444C444C48888899777744C4C4C433C4C4C4C4C
      4C8888899777444444C43334CCC4C4C4C44888899777444C4C43333C4C4C4C4C
      4C38888997744444C4433333CCCCC4CCC433888997744C4C4C4333333C4C4C4C
      4C33888997744444C43333333CCCCCCCC43388899774444C4C333333CC4CCC4C
      4C33888997744444C433333CCCCCCCC33333888997744C4C4C334C4C4CCCCCC3
      33338889977444444433CCCC3CCCCCC3333388F99777444C4C433C433C4CCC4C
      333888F997774444343333333CCCCCCCC4C88FF99777744C333333333C4C4C43
      3C88FFF997777444333333333CCCCCC3348FFFF99777774C333333333C4C3C43
      3FFFFFF997777774333333C333CC3433FFFFFFF9977777774333334C333C4C37
      7FFFFFF9977777777744433444C4477777FFFFF99777777777774C4C4C477777
      777FFFF99777777777777777777777777777FFF9977777777777777777777777
      77777FF9977777777777777777777777777777F9999999999999999999999999
      9999999900000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000}
    Visible = False
  end
  object Image2: TImage
    Left = 249
    Top = 81
    Width = 34
    Height = 37
    Picture.Data = {
      055449636F6E0000010001002020100000000000E80200001600000028000000
      2000000040000000010004000000000080020000000000000000000000000000
      0000000000000000000080000080000000808000800000008000800080800000
      80808000C0C0C0000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000
      FFFFFF0000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000330000000000000000000000033303303303300
      0000000000000003303330333003003300000000000000033003330330002333
      0000000000000030000033003033333000000000000033333330000003330003
      33000000080333333333333333300233330000000F033333333333333302333B
      B03000004F8333333333333333333BB003BB00004FF3333333333333B33BB003
      3BBB00004FF333333333B3BB3BB0033BBBB000004FF83B333B3B3B3BBBB03BBB
      BB0300F04FFF33B3B3B3BBBBBBBBBBBB00330FF04FFF8B3B3333BBBBBBBBBB00
      33330FF044FFF8BBB03033BBBBB330333330FFF444FFF8BB0BB3003B33000333
      3330FF44444FF88B3BBB300000033333B33FFF44444FFF3BB0BBB3000333B33B
      B38FF4444444FF003B0BB333333BBBBBB3FFF44444444FF00030BBBBBBBBBBBB
      BBFF444444440000000303BBB3300000BFF44444440000000000000000000000
      0FF4444400000000000000000000000000444444000000000000000000000000
      0000444400000000000000000000000000000444000000000000000000000000
      0000000400000000000000000000000000000000000000000000000000000000
      00000000FFFFFFFFFFFFFFFFFFFF1FFFFF8003FFFC0000FFF800007FF800007F
      E000003F0000001F0000001F0000000F00000007000000070000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000C000000FE01F003FFFFF80FFFFFFC0FFFFFFF0FFFFFFF8FFFFFFFE
      FFFFFFFF}
    Visible = False
  end
  object Button1: TButton
    Left = 15
    Top = 36
    Width = 124
    Height = 34
    Caption = 'Add Icon To TaskBar'
    TabOrder = 0
    OnClick = Button1Click
  end
  object Button2: TButton
    Left = 12
    Top = 96
    Width = 127
    Height = 34
    Caption = 'Delete Icon from TaskBar'
    TabOrder = 1
    OnClick = Button2Click
  end
  object Button3: TButton
    Left = 12
    Top = 159
    Width = 130
    Height = 31
    Caption = 'ModifyIcon on TaskBar'
    TabOrder = 2
  end
  object Timer1: TTimer
    Interval = 500
    OnTimer = Timer1Timer
    Left = 375
    Top = 21
  end
end
{ DPR file }
program taskbar;
uses
  Forms,
  notify in 'notify.pas' {Form1};
{$R *.RES}
begin
  Application.CreateForm(TForm1, Form1);
  Application.Run;
end.
